<?php
/**
 * Language Include File (English)
 * Can overrule set variables used in different elements
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @translation Peter van Westen <peter@nonumber.nl> NoNumber!
 */

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

/**
 * Variables that can be overruled:
 * $image
 * $title
 * $description
 * $help
 */

if ( $description == 'Syntax help (description)' ) {
	$user =& JFactory::getUser();
	$_tick = '<img src="components/com_rereplacer/images/tick.png" border="0" alt="'.JText::_( 'Yes' ).'" title="'.JText::_( 'Yes' ).'" />';
	$_cross = '<img src="components/com_rereplacer/images/publish_x.png" border="0" alt="'.JText::_( 'No' ).'" title="'.JText::_( 'No' ).'" />';
	$description = '
		Here is an overview of extra codes you can/should use in different situations.
		<table class="adminlist" style="width:auto;">
			<thead>
				<tr>
					<th><label>Syntax</label></th>
					<th style="text-align:left"><label>Description</label></th>
					<th style="text-align:left"><label>Input example</label></th>
					<th style="text-align:left"><label>Output example</label></th>
					<th><label class="hasTip" title="Use in Normal (non-regular expression) searches">Normal</label></th>
					<th><label class="hasTip" title="Use in Regular Expression searches">Regex</label></th>
					<th><label class="hasTip" title="Use in the Search field">Search</label></th>
					<th><label class="hasTip" title="Use in the Replace field">Replace</label></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td style="font-family:monospace">[[comma]]</td>
					<td>Use instead of a comma. Use normal comma\'s to create lists.</td>
					<td style="font-family:monospace">[[comma]]</td>
					<td style="font-family:monospace">,</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_cross.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
				<tr>
					<td style="font-family:monospace">[[space]]</td>
					<td>Use for leading or trailing spaces (otherwise they will get stripped).</td>
					<td style="font-family:monospace">[[space]]</td>
					<td> </td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
				<tr>
					<td style="font-family:monospace">[[counter]]</td>
					<td>This places the number of the occurrence.<br />If your search is found, say, 4 times, the count will show respectively 1 to 4.</td>
					<td style="font-family:monospace">[[counter]]</td>
					<td>1</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_cross.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
				<tr>
					<td style="font-family:monospace">[[random:...-...]]</td>
					<td>This places a random number within the given range.</td>
					<td style="font-family:monospace">[[random:0-100]]</td>
					<td>'.rand( 0, 100 ).'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_cross.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
				<tr>
					<td style="font-family:monospace">[[date:...]]</td>
					<td>Date using <a rel="{handler: \'iframe\', size:{x:window.getSize().scrollSize.x-100, y: window.getSize().size.y-100}}" href="http://www.php.net/manual/function.strftime.php" class="modal">php strftime() format</a>.</td>
					<td style="font-family:monospace">[[date:%A, %d %B %Y]]</td>
					<td>'.JHTML::_( 'date', time(), '%A, %d %B %Y' ).'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_cross.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
				<tr>
					<td style="font-family:monospace">[[user:id]]</td>
					<td>The id number of the user (returns empty if not logged in)</td>
					<td style="font-family:monospace">[[user:id]]</td>
					<td>'.$user->id.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_cross.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
				<tr>
					<td style="font-family:monospace">[[user:username]]</td>
					<td>The login name of the user (returns empty if not logged in)</td>
					<td style="font-family:monospace">[[user:username]]</td>
					<td>'.$user->username.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_cross.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
				<tr>
					<td style="font-family:monospace">[[user:name]]</td>
					<td>The name of the user (returns empty if not logged in)</td>
					<td style="font-family:monospace">[[user:name]]</td>
					<td>'.$user->name.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_tick.'</td>
					<td align="center">'.$_cross.'</td>
					<td align="center">'.$_tick.'</td>
				</tr>
			</tbody>
		</table>

		For help on regular expressions, see the
		<a rel="{handler: \'iframe\', size: {x: 800, y: window.getSize().size.y-100}}" href="index.php?nn_qp=1&folder=administrator.components.com_rereplacer.images&file=image.inc.php" class="modal">Regular Expressions Cheat Sheet</a>
		';
}