<?php
/**
 * ReReplacer List View Template
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import html tooltips
JHTML::_( 'behavior.tooltip' );

// Ordering allowed ?
$ordering = ( $this->lists['order'] == 'ordering' );

echo JText::_( 'List information' );
?>
<p></p>
<form action="<?php echo $this->request_url; ?>" method="post" name="adminForm" >

	<div style="text-align:right">
		<input type="hidden" name="show_searchreplace" value="<?php echo $this->show_searchreplace; ?>" />
		<input type="checkbox" value="1" <?php if ( $this->show_searchreplace == 1 ) { echo 'checked="checked"'; }?> onclick="if ( this.checked ) { show_searchreplace.value = 1; } else { show_searchreplace.value = 2; } submit();" />
		<?php echo JText::_( 'Show search and replace fields' ); ?>

		<input type="hidden" name="show_unpublished" value="<?php echo $this->show_unpublished; ?>" />
		<input type="checkbox" value="1" <?php if ( $this->show_unpublished == 1 ) { echo 'checked="checked"'; }?> onclick="if ( this.checked ) { show_unpublished.value = 1; } else { show_unpublished.value = 2; } submit();" />
		<?php echo JText::_( 'Show unpublished items' ); ?>
	</div>

	<div id="editcell">
		<table class="adminlist">
		<thead>
			<tr>
				<th width="5">
					<?php echo JText::_( 'NUM' ); ?>
				</th>
				<th width="20">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $this->items ); ?>);" />
				</th>
				<th class="title">
					<?php echo JHTML::_('grid.sort', 'Name', 'name', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				</th>
				<th class="title">
					<?php echo JHTML::_('grid.sort', 'Description', 'description', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				</th>
				<?php if ( $this->show_searchreplace == 1 ) { ?>
				<th class="title">
					<?php echo JHTML::_('grid.sort', 'Search', 'search', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				</th>
				<th class="title">
					<?php echo JHTML::_('grid.sort','Replace', 'replace', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				</th>
				<?php } ?>
				<th width="5%" nowrap="nowrap">
					<?php echo JText::_( 'Case' ); ?>
				</th>
				<th width="5%" nowrap="nowrap">
					<?php echo JText::_( 'RegEx' ); ?>
				</th>
				<th width="5%" nowrap="nowrap">
					<?php echo JText::_( 'Admin' ); ?>
				</th>
				<th width="5%" nowrap="nowrap">
					<?php echo JHTML::_('grid.sort', 'Published', 'published', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				</th>
				<th width="80" nowrap="nowrap">
					<?php echo JHTML::_('grid.sort', 'Order', 'ordering', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				</th>
				<th width="1%">
					<?php echo JHTML::_('grid.order', $this->items ); ?>
				</th>
				<th width="5%" nowrap="nowrap">
					<?php echo JHTML::_('grid.sort', 'ID', 'ID_COUNTRY', $this->lists['order_Dir'], $this->lists['order'] ); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="<?php echo ( $this->show_searchreplace == 1 ) ? '13' : '11'; ?>">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<?php
		$rownr = 0;
		$item_count = count( $this->items );
		for ( $i=0; $i < $item_count; $i++ )
		{
			$row =& $this->items[$i];
			// todo: Set this to actual editor...
			$row->editor = '';

			$link 	= JRoute::_( 'index.php?option=com_rereplacer&controller=item&task=edit&cid[]='. $row->id );

			$checked = JHTML::_( 'grid.checkedout', $row, $i ,'id' );
			$published = JHTML::_('grid.published', $row, $i );

			if ( $row->casesensitive ) {
				$case 	= '<img src="components/com_rereplacer/images/tick.png" border="0" alt="'.JText::_( 'Case sensitive' ).'" title="'.JText::_( 'Case sensitive' ).'" />';
			} else {
				$case 	= '<img src="components/com_rereplacer/images/publish_x.png" border="0" alt="'.JText::_( 'Not' ).' '.JText::_( 'Case sensitive' ).'" title="'.JText::_( 'Not' ).' '.JText::_( 'Case sensitive' ).'" />';
			}
			if ( $row->regex ) {
				$regex 	= '<img src="components/com_rereplacer/images/tick.png" border="0" alt="'.JText::_( 'Regular expressions' ).'" title="'.JText::_( 'Regular expressions' ).'" />';
			} else {
				$regex 	= '<img src="components/com_rereplacer/images/publish_x.png" border="0" alt="'.JText::_( 'Not' ).' '.JText::_( 'Regular expressions' ).'" title="'.JText::_( 'Not' ).' '.JText::_( 'Regular expressions' ).'" />';
			}
			if ( $row->enable_in_admin ) {
				$enable_in_admin 	= '<img src="components/com_rereplacer/images/tick.png" border="0" alt="'.JText::_( 'Enable in Admin' ).'" title="'.JText::_( 'Enable in Admin' ).'" />';
			} else {
				$enable_in_admin 	= '<img src="components/com_rereplacer/images/publish_x.png" border="0" alt="'.JText::_( 'Not' ).' '.JText::_( 'Enable in Admin' ).'" title="'.JText::_( 'Not' ).' '.JText::_( 'Enable in Admin' ).'" />';
			}

			?>
			<tr class="<?php echo 'row'.$rownr; ?>">
				<td>
					<?php echo $this->pagination->getRowOffset( $i ); ?>
				</td>
				<td>
					<?php echo $checked; ?>
				</td>
				<td>
					<?php
					if ( JTable::isCheckedOut( $this->user->get('id' ), $row->checked_out ) ) {
						echo $row->name;
					} else {
					?>
						<a href="<?php echo $link; ?>" title="<?php echo JText::_( 'Edit' ); ?>">
							<?php echo $row->name; ?>
						</a>
					<?php
					}
					?>
				</td>
				<td>
					<?php
						$description = explode( '---', str_replace( "\n", '<br />', $row->description ) );
						echo $description['0'];
					?>
				</td>
				<?php if ( $this->show_searchreplace == 1 ) { ?>
				<td>
					<spanclass="hasTip" title="<?php echo str_replace( "\n", '<br />', htmlentities( $row->search ) ); ?>"><?php echo ReReplacerViewList::maxlen( $row->search ); ?></span>
				</td>
				<td>
					<span class="hasTip" title="<?php echo str_replace( "\n", '<br />', htmlentities( $row->replace ) ); ?>"><?php echo ReReplacerViewList::maxlen( $row->replace ); ?></span>
				</td>
				<?php } ?>
				<td align="center">
					<?php echo $case;?>
				</td>
				<td align="center">
					<?php echo $regex;?>
				</td>
				<td align="center">
					<?php echo $enable_in_admin;?>
				</td>
				<td align="center">
					<?php echo $published;?>
				</td>
				<td class="order" colspan="2">
					<span><?php echo $this->pagination->orderUpIcon( $i, true, $this->lists['order_Dir']!='desc'?'orderup':'orderdown', 'Move Up', $ordering ); ?></span>
					<span><?php echo $this->pagination->orderDownIcon( $i, $item_count, true, $this->lists['order_Dir']!='desc'?'orderdown':'orderup', 'Move Down', $ordering ); ?></span>
					<?php $disabled = $ordering ? '' : 'disabled="disabled"'; ?>
					<input type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>" <?php echo $disabled; ?> class="text_area" style="text-align: center" />
				</td>
				<td align="center">
					<?php echo $row->id; ?>
				</td>
			</tr>
			<?php
			$rownr = 1 - $rownr;
		}
		?>
		</table>
	</div>

	<input type="hidden" name="controller" value="list" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>" />
</form>

<script language="javascript" type="text/javascript">
	/**
	* Submit the admin form
	*
	* small hack: let task decides where it comes
	*/
	function submitform( pressbutton )
	{
		var form = document.adminForm;
		if ( pressbutton ) {
			form.task.value=pressbutton;
		}

		if (
			( pressbutton=='add' )||( pressbutton=='copy' )||( pressbutton=='edit' )||( pressbutton=='remove' )
			||( pressbutton=='publish' )||( pressbutton=='unpublish' )
			||( pressbutton=='orderdown' )||( pressbutton=='orderup' )||( pressbutton=='saveorder' )
			||( pressbutton=='export' )
		) {
			form.controller.value="item";
		} else {
			form.controller.value="list";
		}
		try {
			form.onsubmit();
			}
		catch( e ) {}

		form.submit();
	}
</script>