<?php
/**
* Pausing up-down Scroller plugin
* This is a plugin that displays an up-down scroller that pauses between each
* message! The look of the scroller is completely styled using external CSS,
* including the dimensions. Easily create a single line scroller just by
* adjusting the scroller's height appropriately!
* Author: kksou
* Copyright (C) 2006-2008. kksou.com. All Rights Reserved
* Website: http://www.kksou.com/php-gtk2/Joomla-Gadgets/
* v1.0 December 3, 2008
*/

#defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class PausingUpDownScroller {

	function process(&$row, $matches) {
		if (preg_match('/width:([^\s]+)/', $matches[1], $matches2)) {
			$this->width = $matches2[1];
			$this->width = str_replace('px', '', $this->width);
		}

		if (preg_match('/height:([^\s]+)/', $matches[1], $matches2)) {
			$this->height = $matches2[1];
			$this->height = str_replace('px', '', $this->height);
		}

		$this->var = 'pausecontent';
		if (preg_match('/id:([^\s]+)/', $matches[1], $matches2)) {
			$this->var = $matches2[1];
		}

		$this->style = 'pscroller1';
		if (preg_match('/style:([^\s]+)/', $matches[1], $matches2)) {
			$this->style = $matches2[1];
		}

		$this->float = '';
		if (preg_match('/float:(left|right)(\d*)/', $matches[1], $matches2)) {
			$this->float = $matches2[1];
			$this->float_padding = $matches2[2];
		}

		$this->pause = 3000;
		if (preg_match('/pause:(\d+)/', $matches[1], $matches2)) {
			$this->pause = $matches2[1];
			if ($this->pause<10) $this->pause = 3000;
		}

		$this->css = 'pausing_up_down_scroller.css';
		if (preg_match('/css:([^\s]*)/', $matches[1], $matches2)) {
			$this->css = $matches2[1];
		}

		$this->setup_css();
		$str = $this->fix_str2($matches[3]);
		$str2 = $this->process_menu($str);

		$row->text = str_replace($matches[0], $this->menu.$str2, $row->text);
	}

	function process_menu($str) {
		$lines = explode("\n", $str);
		$i = 0;
		$submenu_on = 0;
		$str2 = "<script type=\"text/javascript\">\nvar {$this->var} = new Array()\n";
		$new_item = 1;
		$str_started = 0;
		foreach($lines as $line) {
			if (trim($line)=='') continue;
			if (preg_match('/^---$/', $line)) {
				$new_item = 1;
				++$i;
				continue;
			}

			$line2 = str_replace("'", "\\'", $line);

			if ($new_item) {
				if ($str_started) {
					$str2 .= "'"."\n";
					$str_started = 0;
				}
				$str2 .= $this->var."[$i] = '".$line2;
				$new_item = 0;
				$str_started = 1;
			} else {
				$str2 .= '<br />'.$line2;
			}

		}
		if ($str_started) {
			$str2 .= "'"."\n";
			$str_started = 0;
		}
		$str2 .= '</script>';

		$str3 = '<script type="text/javascript">
new pausescroller('.$this->var.', "'.$this->style.'", "someclass", '.$this->pause.')
</script>';

		if (preg_match('/(left|right)/', $this->float)) {
			$padding = '';
			if ($this->float=='right') $padding = "padding-left:{$this->float_padding}px;";
			elseif ($this->float=='left') $padding = "padding-right:{$this->float_padding}px;";
			#$str2 = "<div style=\"float:$this->float;$padding\"><div class=\"applemenu\">".$str2.'</div></div>';

			$str2 = $str2."<div class=\"b1\" style=\"float:$this->float;$padding\"><div class=\"pscroller\">".$str3."</div>$this->z</div>";
		} else {
			#$str2 = '<div class="applemenu">'.$str2.'</div>';
			#$str2 = $str2."<table cellpadding=\"0\" cellspacing=\"0\" border=0><tr><td><div class=\"pscroller\">".$str3."</div></td></tr><tr><td>$this->z</td></tr></table>";
			$str2 = $str2."<table cellpadding=\"0\" cellspacing=\"0\" border=0><tr><td><div class=\"pscroller\">".$str3."</div></td></tr><tr><td>$this->z</td></tr></table>";
		}

		return $str2;
	}

	function setup_css() {
		$this->menu = '';

		if (!defined('PausingUpDownScroller_js')) {

			#define('PausingUpDownScroller_js', 1);

			$this->menu = "\n\n<!-- \nPowered by Joomla Gadgets from kksou.com
http://www.kksou.com/php-gtk2/Joomla-Gadgets/
-->\n\n";

			$this->z = "<p align=\"right\" style=\"padding:0 0 0 0;margin:0 0 0 0\"><a href=\"http://www.kksou.com/php-gtk2/Joomla/Pausing-up-down-Scroller-plugin.php\" style=\"color:#aaa;text-decoration: none;font-family:Tahoma, Arial, Helvetica, sans-serif;font-size:7pt;font-weight: normal;\">Powered by JoomlaGadgets</a></p>";
			$this->z .= $this->menu;

			$this->menu .= $this->setup_js();
		}

		$css_id = 'PausingUpDownScroller_'.$this->css;
		if (!defined($css_id)) {

			define($css_id, 1);

#$css = $this->read_css('pausing_up_down_scroller.css');
$css = $this->read_css($this->css);

$this->menu .= '
<style type="text/css">

.b1 {
margin: 0 0 0 0;
text-align: right;
}

'.$css.'
</style>
';


		}
	}

	function setup_js() {
		$js = '<script type="text/javascript">

/***********************************************
* Pausing up-down scroller-  Dynamic Drive (www.dynamicdrive.com)
* This notice MUST stay intact for legal use
* Visit http://www.dynamicdrive.com/ for this script and 100s more.
***********************************************/

function pausescroller(content, divId, divClass, delay){
this.content=content //message array content
this.tickerid=divId //ID of ticker div to display information
this.delay=delay //Delay between msg change, in miliseconds.
this.mouseoverBol=0 //Boolean to indicate whether mouse is currently over scroller (and pause it if it is)
this.hiddendivpointer=1 //index of message array for hidden div
document.write(\'<div id="\'+divId+\'" class="\'+divClass+\'" style="position: relative; overflow: hidden"><div class="innerDiv" style="position: absolute; width: 100%" id="\'+divId+\'1">\'+content[0]+\'</div><div class="innerDiv" style="position: absolute; width: 100%; visibility: hidden" id="\'+divId+\'2">\'+content[1]+\'</div></div>\')
var scrollerinstance=this
if (window.addEventListener) //run onload in DOM2 browsers
window.addEventListener("load", function(){scrollerinstance.initialize()}, false)
else if (window.attachEvent) //run onload in IE5.5+
window.attachEvent("onload", function(){scrollerinstance.initialize()})
else if (document.getElementById) //if legacy DOM browsers, just start scroller after 0.5 sec
setTimeout(function(){scrollerinstance.initialize()}, 500)
}

// -------------------------------------------------------------------
// initialize()- Initialize scroller method.
// -Get div objects, set initial positions, start up down animation
// -------------------------------------------------------------------

pausescroller.prototype.initialize=function(){
this.tickerdiv=document.getElementById(this.tickerid)
this.visiblediv=document.getElementById(this.tickerid+"1")
this.hiddendiv=document.getElementById(this.tickerid+"2")
this.visibledivtop=parseInt(pausescroller.getCSSpadding(this.tickerdiv))
//set width of inner DIVs to outer DIV\'s width minus padding (padding assumed to be top padding x 2)
this.visiblediv.style.width=this.hiddendiv.style.width=this.tickerdiv.offsetWidth-(this.visibledivtop*2)+"px"
this.getinline(this.visiblediv, this.hiddendiv)
this.hiddendiv.style.visibility="visible"
var scrollerinstance=this
document.getElementById(this.tickerid).onmouseover=function(){scrollerinstance.mouseoverBol=1}
document.getElementById(this.tickerid).onmouseout=function(){scrollerinstance.mouseoverBol=0}
if (window.attachEvent) //Clean up loose references in IE
window.attachEvent("onunload", function(){scrollerinstance.tickerdiv.onmouseover=scrollerinstance.tickerdiv.onmouseout=null})
setTimeout(function(){scrollerinstance.animateup()}, this.delay)
}


// -------------------------------------------------------------------
// animateup()- Move the two inner divs of the scroller up and in sync
// -------------------------------------------------------------------

pausescroller.prototype.animateup=function(){
var scrollerinstance=this
if (parseInt(this.hiddendiv.style.top)>(this.visibledivtop+5)){
this.visiblediv.style.top=parseInt(this.visiblediv.style.top)-5+"px"
this.hiddendiv.style.top=parseInt(this.hiddendiv.style.top)-5+"px"
setTimeout(function(){scrollerinstance.animateup()}, 50)
}
else{
this.getinline(this.hiddendiv, this.visiblediv)
this.swapdivs()
setTimeout(function(){scrollerinstance.setmessage()}, this.delay)
}
}

// -------------------------------------------------------------------
// swapdivs()- Swap between which is the visible and which is the hidden div
// -------------------------------------------------------------------

pausescroller.prototype.swapdivs=function(){
var tempcontainer=this.visiblediv
this.visiblediv=this.hiddendiv
this.hiddendiv=tempcontainer
}

pausescroller.prototype.getinline=function(div1, div2){
div1.style.top=this.visibledivtop+"px"
div2.style.top=Math.max(div1.parentNode.offsetHeight, div1.offsetHeight)+"px"
}

// -------------------------------------------------------------------
// setmessage()- Populate the hidden div with the next message before it\'s visible
// -------------------------------------------------------------------

pausescroller.prototype.setmessage=function(){
var scrollerinstance=this
if (this.mouseoverBol==1) //if mouse is currently over scoller, do nothing (pause it)
setTimeout(function(){scrollerinstance.setmessage()}, 100)
else{
var i=this.hiddendivpointer
var ceiling=this.content.length
this.hiddendivpointer=(i+1>ceiling-1)? 0 : i+1
this.hiddendiv.innerHTML=this.content[this.hiddendivpointer]
this.animateup()
}
}

pausescroller.getCSSpadding=function(tickerobj){ //get CSS padding value, if any
if (tickerobj.currentStyle)
return tickerobj.currentStyle["paddingTop"]
else if (window.getComputedStyle) //if DOM2
return window.getComputedStyle(tickerobj, "").getPropertyValue("padding-top")
else
return 0
}

</script>';

		return $js;
	}

	function setup_css_file($file) {
		return "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"$this->base_url2/$file\" />\n";
	}

	function read_css($file) {
		#$css_file = $this->base_url2.'/'.$file;
		$css_file = dirname(__FILE__).'/'.$file;
		$css = file_get_contents($css_file);

		$css = str_replace('{$width}', $this->width.'px', $css);
		$css = str_replace('{$height}', $this->height.'px', $css);
		$css = str_replace('{$base}', $this->base_url2, $css);
		return $css;
	}

	function fix_str($str) {
		$str = preg_replace(array('%&lt;\?php(\s|&nbsp;|<br\s/>|<br>|<p>|</p>)%s', '/\?&gt;/s', '/-&gt;/'), array('<?php ', '?>', '->'), $str);
		return $str;
	}

	function fix_str2($str) {
		$str = str_replace('<br>', "\n", $str);
		$str = str_replace('<br />', "\n", $str);
		$str = str_replace('<p>', "\n", $str);
		$str = str_replace('</p>', "\n", $str);
		$str = str_replace('&#39;', "'", $str);
		$str = str_replace('&quot;', '"', $str);
		$str = str_replace('&lt;', '<', $str);
		$str = str_replace('&gt;', '>', $str);
		$str = str_replace('&amp;', '&', $str);
		$str = str_replace('&nbsp;', ' ', $str);
		$str = str_replace('&#160;', "\t", $str);
		$str = str_replace("\r", "", $str);
		$str = str_replace("\n\n", "\n", $str);
		$str = str_replace(chr(hexdec('C2')).chr(hexdec('A0')), '', $str);
		$str = str_replace('~', "<br />", $str);
		return $str;
	}

	function get_param($module, $ver) {
		if ($ver=='1.0') {
			$this->get_param10($module);
		} elseif ($ver=='1.5') {
			$this->get_param15($module);
		}

		if ($this->width<=10) $this->width = 200;
		if ($this->height<=3) $this->height = 100;
	}

	function get_param10($module) {
		global $database, $_MAMBOTS;

		if ( !isset($_MAMBOTS->_content_mambot_params[$module]) ) {
			$query = "SELECT params"
			. "\n FROM #__mambots"
			. "\n WHERE element = '$module'"
			. "\n AND folder = 'content'"
			;
			$database->setQuery( $query );
			$database->loadObject($mambot);
			$_MAMBOTS->_content_mambot_params[$module] = $mambot;
		}

		$mambot = $_MAMBOTS->_content_mambot_params[$module];
		$botParams = new mosParameters( $mambot->params );
		$this->width = $botParams->def( 'width', '200' );
		$this->height = $botParams->def( 'height', '100' );

		global $mosConfig_live_site;
		$this->base_url = $mosConfig_live_site."/mambots/content";
		$this->base_url2 = $mosConfig_live_site."/mambots/content/$module";
	}

	function get_param15($module) {
		$plugin =& JPluginHelper::getPlugin('content', $module);
		$pluginParams = new JParameter( $plugin->params );
		$this->width = $pluginParams->get('width');
		$this->height = $pluginParams->get('height');

		$mosConfig_live_site = JURI::base();
		$this->base_url = $mosConfig_live_site."plugins/content";
		$this->base_url2 = $mosConfig_live_site."plugins/content/$module";
	}
}

?>
