<?php
/**
 * @package    Advanced Module Manager
 * @version    0.2.2a
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/advancedmodulemanager
 * @copyright  Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

/**
 * BASE ON JOOMLA CORE FILE:
 * /administrator/components/com_modules/admin.modules.html.php
 * Altered / added parts are commented with: (C) NoNumber!
 */

/**
* @version		$Id: admin.modules.html.php 11672 2009-03-08 20:39:41Z willebil $
* @package		Joomla
* @subpackage	Modules
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
* @package		Joomla
* @subpackage	Modules
*/
class HTML_modules
{
	/**
	* Writes a list of the defined modules
	* @param array An array of category objects
	*/
	function view( &$rows, &$client, &$page, &$lists )
	{
		$user =& JFactory::getUser();

		//Ordering allowed ?
		$ordering = ($lists['order'] == 'm.ordering' || $lists['order'] == 'm.position');

		JHTML::_('behavior.tooltip');
// >>> (C) NoNumber! >>>
		$plugin = JPluginHelper::getPlugin( 'system', 'advancedmodules' );
		$plugin_params = new JParameter( $plugin->params );
		if ( $plugin_params->get( 'open_in_modals', 1 ) ) {
			JHTML::_('behavior.modal');
		}
		?>
		<form action="<?php echo JRoute::_( 'index.php?option=com_advancedmodules'); ?>" method="post" target="" name="adminForm">
		<?php
// <<< (C) NoNumber! <<<
		?>

			<table>
			<tr>
				<td align="left" width="100%">
					<?php echo JText::_( 'Filter' ); ?>:
					<input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
					<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
					<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
				</td>
				<td nowrap="nowrap">
					<?php
					echo $lists['assigned'];
					echo $lists['position'];
					echo $lists['type'];
					echo $lists['state'];
					?>
				</td>
			</tr>
			</table>

			<table class="adminlist" cellspacing="1">
			<thead>
			<tr>
				<th width="20">
					<?php echo JText::_( 'NUM' ); ?>
				</th>
				<th width="20">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows );?>);" />
				</th>
				<th class="title">
					<?php echo JHTML::_('grid.sort', 'Module Name', 'm.title', @$lists['order_Dir'], @$lists['order'] ); ?>
				</th>
				<th nowrap="nowrap" width="7%">
					<?php echo JHTML::_('grid.sort', 'Published', 'm.published', @$lists['order_Dir'], @$lists['order'] ); ?>
				</th>
				<th width="80" nowrap="nowrap">
					<?php echo JHTML::_('grid.sort', 'Order', 'm.ordering', @$lists['order_Dir'], @$lists['order'] ); ?>
				</th>
				<th width="1%">
					<?php if ($ordering) echo JHTML::_('grid.order',  $rows ); ?>
				</th>
				<?php
				if ( $client->id == 0 ) {
					?>
					<th nowrap="nowrap" width="7%">
						<?php echo JHTML::_('grid.sort', 'Access', 'groupname', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<?php
				}
				?>
				<th nowrap="nowrap" width="7%">
					<?php echo JHTML::_('grid.sort',   'Position', 'm.position', @$lists['order_Dir'], @$lists['order'] ); ?>
				</th>
				<th nowrap="nowrap" width="5%">
					<?php echo JHTML::_('grid.sort',   'Pages', 'pages', @$lists['order_Dir'], @$lists['order'] ); ?>
				</th>
				<th nowrap="nowrap" width="10%"  class="title">
					<?php echo JHTML::_('grid.sort',   'Type', 'm.module', @$lists['order_Dir'], @$lists['order'] ); ?>
				</th>
				<th nowrap="nowrap" width="1%">
					<?php echo JHTML::_('grid.sort',   'ID', 'm.id', @$lists['order_Dir'], @$lists['order'] ); ?>
				</th>
			</tr>
			</thead>
			<tfoot>
			<tr>
				<td colspan="12">
					<?php echo $page->getListFooter(); ?>
				</td>
			</tr>
			</tfoot>
			<tbody>
			<?php
			$k = 0;
			for ($i=0, $n=count( $rows ); $i < $n; $i++) {
				$row 	= &$rows[$i];

// >>> (C) NoNumber! >>>
				$url = JRoute::_( 'index.php?option=com_advancedmodules&client='. $client->id .'&task=edit&cid[]='. $row->id );
				$link = '<span class="editlinktip hasTip" title="'.JText::_( 'Edit Module' ).'::'.$row->title.'">'
						.'<a href="'.$url.'">'
							.$row->title
						.'</a>'
					.'</span> ';
				if ( $plugin_params->get( 'open_in_modals', 1 ) ) {
					$modal = '<span class="hasTip" title="'.JText::_( 'Edit Module' ).'::'.$row->title.'<br /><br /><strong>'.JText::_( 'Open in modal window' ).'</strong>">'
							.'<a href="'.$url.'&tmpl=component"'
							.' class="modal" rel="{handler: \'iframe\', size: {x:window.getSize().scrollSize.x-100, y: window.getSize().size.y-100}}">'
								.'<img src="components/com_advancedmodules/images/edit.png" alt="'.JText::_( 'Open in modal window' ).'" />'
							.'</a>'
						.'</span> ';
					$link = $modal.$link;
				}

// <<< (C) NoNumber! <<<

				$access 	= JHTML::_('grid.access',   $row, $i );
				$checked 	= JHTML::_('grid.checkedout',   $row, $i );
				$published 	= JHTML::_('grid.published', $row, $i );
				?>
				<tr class="<?php echo "row$k"; ?>">
					<td align="right">
						<?php echo $page->getRowOffset( $i ); ?>
					</td>
					<td width="20">
						<?php echo $checked; ?>
					</td>
					<td>
					<?php
					if (  JTable::isCheckedOut($user->get ('id'), $row->checked_out ) ) {
						echo $row->title;
					} else {
// >>> (C) NoNumber! >>>
						echo $link;
// <<< (C) NoNumber! <<<
					}
					?>
					</td>
					<td align="center">
						<?php echo $published;?>
					</td>
					<td class="order" colspan="2">
						<span><?php echo $page->orderUpIcon( $i, ($row->position == @$rows[$i-1]->position), 'orderup', 'Move Up', $ordering ); ?></span>
						<span><?php echo $page->orderDownIcon( $i, $n, ($row->position == @$rows[$i+1]->position),'orderdown', 'Move Down', $ordering ); ?></span>
						<?php $disabled = $ordering ?  '' : 'disabled="disabled"'; ?>
						<input type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>" <?php echo $disabled ?> class="text_area" style="text-align: center" />
					</td>
					<?php
					if ( $client->id == 0 ) {
						?>
						<td align="center">
							<?php echo $access;?>
						</td>
						<?php
					}
					?>
					<td align="center">
						<?php echo $row->position; ?>
					</td>
					<td align="center">
						<?php
						if (is_null( $row->pages )) {
							echo JText::_( 'None' );
						} else if ($row->pages > 0) {
							echo JText::_( 'Varies' );
						} else {
							echo JText::_( 'All' );
						}
						?>
					</td>
					<td>
						<?php echo $row->module ? $row->module : JText::_( 'User' );?>
					</td>
					<td>
						<?php echo $row->id;?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
			</table>

<?php // >>> (C) NoNumber! >>> ?>
		<input type="hidden" name="option" value="com_advancedmodules" />
<?php // <<< (C) NoNumber! <<< ?>
		<input type="hidden" name="client" value="<?php echo $client->id;?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
		<?php echo JHTML::_( 'form.token' ); ?>
		</form>
		<?php
	}

	/**
	* Writes the edit form for new and existing module
	*
	* A new record is defined when <var>$row</var> is passed with the <var>id</var>
	* property set to 0.
	* @param JTableCategory The category object
	* @param array <p>The modules of the left side.  The array elements are in the form
	* <var>$leftorder[<i>order</i>] = <i>label</i></var>
	* where <i>order</i> is the module order from the db table and <i>label</i> is a
	* text label associciated with the order.</p>
	* @param array See notes for leftorder
	* @param array An array of select lists
	* @param object Parameters
	*/
	function edit( &$model, &$row, &$orders2, &$lists, &$params, $client )
	{
		JRequest::setVar( 'hidemainmenu', 1 );

		// clean item data
		JFilterOutput::objectHTMLSafe( $row, ENT_QUOTES, 'content' );

// >>> (C) NoNumber! >>>
		$document =& JFactory::getDocument();
		$editor =& JFactory::getEditor();

		$document->addStyleDeclaration( '.combobox { z-index: 10 !important; }' );
		$document->addScript( JURI::root(true).'/plugins/system/nonumberelements/elements/toggler.js' );

		$script = "
			function submitbutton(pressbutton) {
				if ( ( pressbutton == 'save' || pressbutton == 'apply' ) && ( document.adminForm.title.value == '' ) ) {
					alert( '".JText::_( 'Module must have a title', true )."' );
				} else {
					if ( pressbutton == 'save' ) {
						document.adminForm.target = '_parent';
					}
		";
		if ( $row->module == '' || $row->module == 'mod_custom' ) {
			$script .= $editor->save( 'content' );
		}
		$script .= "
					submitform(pressbutton);
				}
			}
			var originalOrder 	= '".$row->ordering."';
			var originalPos 	= '".$row->position."';
			var orders 			= new Array();	// array in the format [key,value,text]
		";
		$i = 0;
		foreach ( $orders2 as $k => $items ) {
			foreach ( $items as $v ) {
				$script .= "\n".'	orders['.$i++.'] = new Array( "'.$k.'","'.$v->value.'","'.$v->text.'" );';
			}
		}
		$script .= "
			window.addEvent( 'domready', function() {
				$('combobox-position-select').addEvent('change', function() {
					changeDynaList('ordering', orders, document.adminForm.position.value, 0, 0);
				});
				$('position').addEvent('change', function() {
					changeDynaList('ordering', orders, document.adminForm.position.value, 0, 0);
				});
				if ( !nnTogglerSet ) {
					nnTogglerSet = new nnToggler();
				}
			});
		";
		$document->addScriptDeclaration( $script );

		$tmpl = JRequest::getCmd( 'tmpl' );

		if ( $tmpl == 'component' ) {
			HTML_modules::placeModalHeader( 'edit' );
		}

		JHTML::_('behavior.combobox');

		jimport('joomla.html.pane');
        // TODO: allowAllClose should default true in J!1.6, so remove the array when it does.
		$pane = &JPane::getInstance('sliders', array('allowAllClose' => true));

		JHTML::_('behavior.tooltip');
		?>
		<form action="<?php echo JRoute::_( 'index.php'); ?>" method="post" name="adminForm">
<?php // <<< (C) NoNumber! <<< ?>
		<div class="col width-50">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Details' ); ?></legend>

				<table class="admintable" cellspacing="1">
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Module Type' ); ?>:
						</td>
						<td>
							<strong>
								<?php echo JText::_($row->module); ?>
							</strong>
						</td>
					</tr>
					<tr>
						<td class="key">
							<label for="title">
								<?php echo JText::_( 'Title' ); ?>:
							</label>
						</td>
						<td>
							<input class="text_area" type="text" name="title" id="title" size="35" value="<?php echo $row->title; ?>" />
						</td>
					</tr>
					<tr>
						<td width="100" class="key">
							<?php echo JText::_( 'Show title' ); ?>:
						</td>
						<td>
							<?php echo $lists['showtitle']; ?>
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Published' ); ?>:
						</td>
						<td>
							<?php echo $lists['published']; ?>
						</td>
					</tr>
				<?php
// >>> (C) NoNumber! >>>
					if ( $row->client_id != 1 ) :
						$plugin = JPluginHelper::getPlugin( 'system', 'advancedmodules' );
						$plugin_params = new JParameter( $plugin->params );
						if ( $plugin_params->get( 'show_hideempty', 1 ) ) :
				?>
					<tr>
						<td valign="top" class="key">
							<label for="hideempty" class="hasTip" title="<?php echo JText::_( 'Hide if empty' ); ?>::<?php echo JText::_( 'Hides the module if its output is empty' ); ?>">
								<?php echo JText::_( 'Hide if empty', 0 ); ?>:
							</label>
						</td>
						<td>
							<?php echo $lists['hideempty']; ?>
						</td>
					</tr>
				<?php
						endif;
					endif;
				?>
					<tr>
						<td valign="top" class="key">
							<label for="position" class="hasTip" title="<?php echo JText::_('MODULE_POSITION_TIP_TITLE', true); ?>::<?php echo JText::_('MODULE_POSITION_TIP_TEXT', true); ?>">
								<?php echo JText::_( 'Position' ); ?>:
							</label>
						</td>
						<td>
							<input type="text" id="position" class="combobox" name="position" value="<?php echo $row->position; ?>" />
							<ul id="combobox-position" style="display:none;">
							<?php
								$positions = $model->getPositions();
								foreach ($positions as $position) {
									echo '<li>'.$position.'</li>';
								}
							?>
							</ul>
						</td>
					</tr>
<?php
// <<< (C) NoNumber! <<<
?>
					<tr>
						<td valign="top"  class="key">
							<label for="ordering">
								<?php echo JText::_( 'Order' ); ?>:
							</label>
						</td>
						<td>
							<script language="javascript" type="text/javascript">
							<!--
							writeDynaList( 'class="inputbox" name="ordering" id="ordering" size="1"', orders, originalPos, originalPos, originalOrder );
							//-->
							</script>
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<label for="access">
								<?php echo JText::_( 'Access Level' ); ?>:
							</label>
						</td>
						<td>
							<?php echo $lists['access']; ?>
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'ID' ); ?>:
						</td>
						<td>
							<?php echo $row->id; ?>
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Description' ); ?>:
						</td>
						<td>
							<?php
// >>> (C) NoNumber! >>>
								echo JText::_( html_entity_decode( $row->description ) );
// <<< (C) NoNumber! <<<
							?>
						</td>
					</tr>
				</table>
			</fieldset>
		</div>

		<div class="col width-50">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Parameters' ); ?></legend>

				<?php
					echo $pane->startPane("menu-pane");
					echo $pane->startPanel(JText :: _('Module Parameters'), "param-page");
					$p = $params;
					if ($params = $p->render('params')) :
						echo $params;
					else :
						echo "<div style=\"text-align: center; padding: 5px; \">".JText::_('There are no parameters for this item')."</div>";
					endif;
					echo $pane->endPanel();

// >>> (C) NoNumber! >>>
					if ($row->client_id != 1) {
						echo $pane->startPane("menu-pane");
						echo $pane->startPanel(JText :: _('Module Assignment'), "assignment-page" );
						echo HTML_modules::renderAssignments( $row, $lists );
						echo $pane->endPanel();
					}
// <<< (C) NoNumber! <<<

					if ($p->getNumParams('advanced')) {
						echo $pane->startPanel(JText :: _('Advanced Parameters'), "advanced-page");
						if($params = $p->render('params', 'advanced')) :
							echo $params;
						else :
							echo "<div  style=\"text-align: center; padding: 5px; \">".JText::_('There are no advanced parameters for this item')."</div>";
						endif;
						echo $pane->endPanel();
					}

					if ($p->getNumParams('legacy')) {
						echo $pane->startPanel(JText :: _('Legacy Parameters'), "legacy-page");
						if($params = $p->render('params', 'legacy')) :
							echo $params;
						else :
							echo "<div  style=\"text-align: center; padding: 5px; \">".JText::_('There are no legacy parameters for this item')."</div>";
						endif;
						echo $pane->endPanel();
					}

					if ($p->getNumParams('other')) {
						echo $pane->startPanel(JText :: _('Other Parameters'), "other-page");
						if($params = $p->render('params', 'other')) :
							echo $params;
						else :
							echo "<div  style=\"text-align: center; padding: 5px; \">".JText::_('There are no other parameters for this item')."</div>";
  						endif;
						echo $pane->endPanel();
					}
					echo $pane->endPane();
				?>
			</fieldset>
		</div>
		<div class="clr"></div>

		<?php
		if ( !$row->module || $row->module == 'custom' || $row->module == 'mod_custom' ) {
			?>
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Custom Output' ); ?></legend>

				<?php
				// parameters : areaname, content, width, height, cols, rows
				echo $editor->display( 'content', $row->content, '100%', '400', '60', '20', array('pagebreak', 'readmore') ) ;
				?>

			</fieldset>
			<?php
		}
		?>

<?php // >>> (C) NoNumber! >>> ?>
		<input type="hidden" name="option" value="com_advancedmodules" />
		<input type="hidden" name="tmpl" value="<?php echo $tmpl; ?>" />
<?php // <<< (C) NoNumber! <<< ?>
		<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
		<input type="hidden" name="cid[]" value="<?php echo $row->id; ?>" />
		<input type="hidden" name="original" value="<?php echo $row->ordering; ?>" />
		<input type="hidden" name="module" value="<?php echo $row->module; ?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="client" value="<?php echo $client->id ?>" />
		<?php echo JHTML::_( 'form.token' ); ?>
		</form>
	<?php
	}

	function preview()
	{
		$editor =& JFactory::getEditor();

		?>
		<script type="text/javascript">
			var form = window.top.document.adminForm
			var title = form.title.value;

			var alltext = window.top.<?php echo $editor->getContent('text') ?>;
		</script>

		<table align="center" width="90%" cellspacing="2" cellpadding="2" border="0">
			<tr>
				<td class="contentheading" colspan="2"><script>document.write(title);</script></td>
			</tr>
<?php // >>> (C) NoNumber! >>> ?>
			<tr>
				<td valign="top" height="90%" colspan="2"><script type="text/javascript">document.write(alltext + "");</script></td>
			</tr>
<?php // <<<< (C) NoNumber! <<<< ?>
		</table>
		<?php
	}

/**
	/**
	* Displays a selection list for module types
	*/
	function add(&$modules, $client)
	{
 		JHTML::_('behavior.tooltip');

		?>
<?php // >>> (C) NoNumber! >>> ?>
		<form action="<?php echo JRoute::_( 'index.php'); ?>" method="post" name="adminForm">
<?php // <<< (C) NoNumber! <<< ?>

		<table class="adminlist" cellpadding="1" summary="Add Module">
		<thead>
		<tr>
			<th colspan="4">
			<?php echo JText::_('Modules'); ?>
			</th>
		</tr>
		</thead>
		<tfoot>
		<tr>
			<th colspan="4">&nbsp;
			</th>
		</tr>
		</tfoot>
		<tbody>
		<?php
		$altRow = 0;
		$count = count($modules);
		// Variable-column ready, just pass $cols in.
		$cols = 2;
		$pct = floor(100 / $cols);
		$rows = ceil($count / $cols);
		$posn = 0;
		do {
			?>
			<tr class="<?php echo 'row' . $altRow; ?>" valign="top">
			<?php
			$altRow = 1 - $altRow;
			for ($col = 0; $col < $cols; ++$col) :
				if (($mod = $posn + $col * $rows) >= $count) :
					?>
					<td width="<?php echo $pct; ?>%">&nbsp;</td>
					<?php
					continue;
				endif;
				$item = &$modules[$mod];
// >>> (C) NoNumber! >>>
				$link = 'index.php?option=com_advancedmodules&amp;task=edit&amp;module='
					. $item->module . '&amp;created=1&amp;client=' . $client->id;

				echo '
					<td width="'.$pct.'%">
						<span class="editlinktip hasTip" title="'
							.htmlspecialchars($item->name.' :: '
							.JText::_(stripslashes($item->descrip)), ENT_QUOTES, 'UTF-8')
							.'" name="module" value="'.$item->module.'" onclick="isChecked(this.checked);">
						<input type="radio" name="module" value="'
							.$item->module.'" id="cb<?php echo $mod; ?>"/><a href="'
							.$link.'">'
							.htmlspecialchars( $item->name, ENT_QUOTES, 'UTF-8' )
							.'</a></span>
					</td>';
// <<< (C) NoNumber! <<<
			endfor;
			++$posn;
			?>
			</tr>
		<?php
		} while ($posn < $rows);
		?>
		</tbody>
		</table>

<?php // >>> (C) NoNumber! >>> ?>
		<input type="hidden" name="option" value="com_advancedmodules" />
<?php // <<< (C) NoNumber! <<< ?>
		<input type="hidden" name="client" value="<?php echo $client->id; ?>" />
		<input type="hidden" name="created" value="1" />
		<input type="hidden" name="task" value="edit" />
		<input type="hidden" name="boxchecked" value="0" />
		<?php echo JHTML::_('form.token'); ?>
		</form>
		<?php
	}
// >>> (C) NoNumber! >>>
	/**
	* Displays a selection list for module types
	*/
	function placeModalHeader( $action )
	{
		$document =& JFactory::getDocument();

		$document->addStyleSheet( JURI::base(true).'/templates/system/css/system.css' );
		$document->addStyleSheet( JURI::base(true).'/templates/khepri/css/template.css' );
		$document->addStyleSheet( JURI::base(true).'/templates/khepri/css/rounded.css' );

		// Render the toolbar
		echo '
			<div class="padding"><div id="toolbar-box">
	   			<div class="t"><div class="t"><div class="t"></div></div></div>
				<div class="m">
					<div class="toolbar" id="toolbar">
						<table class="toolbar"><tr>
							<td class="button" id="toolbar-save">
								<a href="#" onclick="javascript: submitbutton(\'save\')" class="toolbar">
									<span class="icon-32-save" title="'.JText::_( 'Save' ).'"></span>
									'.JText::_( 'Save' ).'
								</a>
							</td>
							<td class="button" id="toolbar-apply">
								<a href="#" onclick="javascript: submitbutton(\'apply\')" class="toolbar">
									<span class="icon-32-apply" title="'.JText::_( 'Apply' ).'"></span>
									'.JText::_( 'Apply' ).'
								</a>
							</td>
							<td class="button" id="toolbar-cancel">
								<a href="#" onclick="javascript: parent.location.href=parent.location; parent.SqueezeBox.window.setStyle(\'display\', \'none\');return false;" class="toolbar">
									<span class="icon-32-cancel" title="'.JText::_( 'Close' ).'"></span>
									'.JText::_( 'Close' ).'
								</a>
							</td>
						</tr></table>
					</div>
					<div class="header icon-48-module">
						'.JText::_( 'Module' ).': <small><small>[ '.JText::_( $action ).' ]</small></small>
					</div>
					<div class="clr"></div>
				</div>
				<div class="b"><div class="b"><div class="b"></div></div>
			</div></div>';
	}
	function renderAssignments( &$row, &$lists )
	{
		// Loads English language file as fallback (for undefined stuff in other language file)
		$file = JPATH_ADMINISTRATOR.DS.'language'.DS.'en-GB'.DS.'en-GB.com_advancedmodules.ini';
		$lang =& JFactory::getLanguage();
		$lang->_load( $file, 'com_advancedmodules', 0 );

		$plugin = JPluginHelper::getPlugin( 'system', 'advancedmodules' );
		$plugin_params = new JParameter( $plugin->params );

		if ( $plugin_params->get( 'show_mirror_module', 1 ) ) {
?>
		<table class="admintable" cellspacing="1">
			<tr>
				<td valign="top" class="key"><label class="hasTip" title="<?php echo JText::_( 'Mirror Module (description)' ); ?>"><?php echo JText::_( 'Mirror Module' ); ?></label></td>
				<td>
					<?php echo $lists['mirror_module']; ?>
				</td>
			</tr>
		</table>
		<div id="advancedparams[mirror_module].1" class="nntoggler" style="visibility: hidden;">
			<table class="admintable" cellspacing="1">
				<tr>
					<td valign="top" class="key"><label class="hasTip" title="<?php echo JText::_( 'Mirror Module ID (description)' ); ?>"><?php echo JText::_( 'Mirror Module ID' ); ?></label></td>
					<td>
						<?php echo $lists['mirror_moduleid']; ?>
					</td>
				</tr>
			</table>
		</div>
		<div id="advancedparams[mirror_module].0" class="nntoggler" style="visibility: hidden;">

<?php
		} else {
			echo '<div>';
		}
		if (	$plugin_params->get( 'show_match_method', 1 )
			&& (	$plugin_params->get( 'show_limit_date', 1 )
				||	$plugin_params->get( 'show_limit_seccats', 1 )
				||	$plugin_params->get( 'show_limit_articles', 1 )
				||	$plugin_params->get( 'show_limit_usergrouplevels', 1 )
				||	$plugin_params->get( 'show_limit_components', 1 )
				||	$plugin_params->get( 'show_limit_languages', 1 )
				||	$plugin_params->get( 'show_limit_templates', 1 )
			)
		) {
?>
		<table class="admintable" cellspacing="1">
			<tr>
				<td valign="top" class="key"><label class="hasTip" title="<?php echo JText::_( 'Matching Method (description)' ); ?>"><?php echo JText::_( 'Matching Method' ); ?></label></td>
				<td>
					<?php echo $lists['match_method']; ?>
					<div id="advancedparams[match_method].and" class="nntoggler" style="visibility: hidden;">
						<p style="margin:0 5px;"><?php echo JText::_( 'AND (description)' ); ?></p>
					</div>
					<div id="advancedparams[match_method].or" class="nntoggler" style="visibility: hidden;">
						<p style="margin:0 5px;"><?php echo JText::_( 'OR (description)' ); ?></p>
					</div>
				</td>
			</tr>
		</table>

<?php
		}
?>

		<!-- MENU ITEMS -->
		<fieldset class="adminform">
			<legend><?php echo JText::_( 'Menu Items' ); ?></legend>
			<script type="text/javascript">
				function allselections() {
					var e = document.getElementById('selections');
						e.disabled = true;
					var i = 0;
					var n = e.options.length;
					for (i = 0; i < n; i++) {
						e.options[i].disabled = true;
						e.options[i].selected = true;
					}
				}
				function disableselections() {
					var e = document.getElementById('selections');
						e.disabled = true;
					var i = 0;
					var n = e.options.length;
					for (i = 0; i < n; i++) {
						e.options[i].disabled = true;
						e.options[i].selected = false;
					}
				}
				function enableselections() {
					var e = document.getElementById('selections');
						e.disabled = false;
					var i = 0;
					var n = e.options.length;
					for (i = 0; i < n; i++) {
						e.options[i].disabled = false;
						e.options[i].selected = !(e.options[i].selected);
					}
				}
			</script>
			<table class="admintable" cellspacing="1">
				<tr>
					<td valign="top" class="key"><label class="hasTip" title="<?php echo JText::sprintf( 'Publish on ...', JText::_( 'Menu Items' ) ); ?>"><?php echo JText::_( 'Publish on' ); ?></label></td>
					<td>
						<?php
							switch ( $row->pages ) {
								case 'all':
								case 'none':
								case 'excludeselect':
									$menu_option = $row->pages;
									break;
								default:
									$menu_option = 'select';
									break;
							}

						?>
						<div style="float:left;">
							<input id="menus-all" type="radio" name="menus" value="all" onclick="allselections();" <?php if ( $menu_option == 'all' ) { echo 'checked="checked"'; } ?> />
							<div style="display:inline-block;">
								<div id="advancedparams[match_method].and" class="nntoggler nntoggler_nofx" style="visibility: hidden;">
									<label class="hasTip" title="<?php echo JText::sprintf( 'All (description)', JText::_( 'Menu Items' ) ); ?>">
										<?php echo JText::_( 'All' ); ?>
									</label>
								</div>
								<div id="advancedparams[match_method].or" class="nntoggler nntoggler_nofx" style="visibility: hidden;">
									<label class="hasTip" title="<?php echo JText::sprintf( 'Ignore this (description)', JText::_( 'Menu Items' ) ); ?>">
										<?php echo JText::_( 'Ignore this' ); ?>
									</label>
								</div>
							</div>
						</div>
						<div style="float:left;">
							<input id="menus-select" type="radio" name="menus" value="select" onclick="enableselections();" <?php if ( $menu_option == 'select' ) { echo 'checked="checked"'; } ?> />
							<label class="hasTip" title="<?php echo JText::sprintf( 'Selection (description)', JText::_( 'Menu Items' ) ); ?>">
								<?php echo JText::_( 'Selection' ); ?>
							</label>
						</div>
						<div style="float:left;">
							<input id="menus-excludeselect" type="radio" name="menus" value="excludeselect" onclick="enableselections();" <?php if ( $menu_option == 'excludeselect' ) { echo 'checked="checked"'; } ?> />
							<label class="hasTip" title="<?php echo JText::sprintf( 'Exclude Selection (description)', JText::_( 'Menu Items' ) ); ?>">
								<?php echo JText::_( 'Exclude Selection' ); ?>
							</label>
						</div>
						<div style="float:left;">
							<div id="advancedparams[match_method].and" class="nntoggler nntoggler_nofx" style="visibility: hidden;">
								<input id="menus-none" type="radio" name="menus" value="none" onclick="disableselections();" <?php if ( $menu_option == 'none' ) { echo 'checked="checked"'; } ?> />
								<label class="hasTip" title="<?php echo JText::sprintf( 'None (description)', JText::_( 'Menu Items' ) ); ?>">
									<?php echo JText::_( 'None' ); ?>
								</label>
							</div>
						</div>
					</td>
				</tr>
			</table>
			<div id="menus.select menus.excludeselect" class="nntoggler" style="visibility: hidden;">
				<table class="admintable" cellspacing="1">
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Also on child items' ); ?>
						</td>
						<td>
							<?php echo $lists['on_children']; ?>
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<div><div id="menus.select" class="nntoggler" style="visibility: hidden;">
								<?php echo JText::_( 'Include' ); ?>
							</div><div id="menus.excludeselect" class="nntoggler" style="visibility: hidden;">
								<?php echo JText::_( 'Exclude' ); ?>
							</div></div>
						</td>
						<td>
							<?php echo $lists['selections']; ?>
						</td>
					</tr>
				</table>
			</div>
			<?php if ($row->pages == 'all') { ?>
				<script type="text/javascript">allselections();</script>
			<?php } elseif ($row->pages == 'none') { ?>
				<script type="text/javascript">disableselections();</script>
			<?php } ?>
		</fieldset>
<?php
		if ( $plugin_params->get( 'show_limit_seccats', 1 ) ) {
			HTML_modules::placeOption( 'seccats', 'Sections / Categories', $lists, $row->advancedparams->get( 'limit_seccats' ) );
		}
		if ( $plugin_params->get( 'show_limit_articles', 1 ) ) {
			HTML_modules::placeOption( 'articles', 'Articles', $lists, $row->advancedparams->get( 'limit_articles' ) );
		}
		if ( $plugin_params->get( 'show_limit_components', 1 ) ) {
			HTML_modules::placeOption( 'components', 'Components', $lists, $row->advancedparams->get( 'limit_components' ), 2 );
		}
		if ( $plugin_params->get( 'show_limit_date', 1 ) ) {
			HTML_modules::placeOption( 'date', 'Date', $lists, $row->advancedparams->get( 'limit_date' ), 2 );
		}
		if ( $plugin_params->get( 'show_limit_usergrouplevels', 1 ) ) {
			HTML_modules::placeOption( 'usergrouplevels', 'User Group Levels', $lists, $row->advancedparams->get( 'limit_usergrouplevels' ), 2 );
		}
		if ( $plugin_params->get( 'show_limit_languages', 1 ) ) {
			HTML_modules::placeOption( 'languages', 'Languages', $lists, $row->advancedparams->get( 'limit_languages' ), 2 );
		}
		if ( $plugin_params->get( 'show_limit_templates', 1 ) ) {
			HTML_modules::placeOption( 'templates', 'Templates', $lists, $row->advancedparams->get( 'limit_templates' ), 2 );
		}
?>
		</div>
<?php
	}

	function placeOption( $type, $name, &$lists, $active = 1, $options = 3 )
	{
?>
		<!-- <?php echo strtoupper( $name ); ?> -->
		<fieldset class="adminform">
		<legend><?php echo JText::_( $name ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tr>
					<td valign="top" class="key"><label class="hasTip" title="<?php echo JText::sprintf( 'Publish on ...', JText::_( $name ) ); ?>"><?php echo JText::_( 'Publish on' ); ?></label></td>
					<td class="paramlist_value">
						<div style="float:left;">
							<input type="radio" name="advancedparams[limit_<?php echo $type; ?>]" value="0" <?php if ( $active < 1 ) { echo 'checked="checked"'; } ?> />
							<div style="display:inline-block;">
								<div id="advancedparams[match_method].and" class="nntoggler nntoggler_nofx" style="visibility: hidden;">
									<label class="hasTip" title="<?php echo JText::sprintf( 'All (description)', JText::_( $name ) ); ?>">
										<?php echo JText::_( 'All' ); ?>
									</label>
								</div>
								<div id="advancedparams[match_method].or" class="nntoggler nntoggler_nofx" style="visibility: hidden;">
									<label class="hasTip" title="<?php echo JText::sprintf( 'Ignore this (description)', JText::_( $name ) ); ?>">
										<?php echo JText::_( 'Ignore this' ); ?>
									</label>
								</div>
							</div>
						</div>
					<?php if ( $options > 0 ) : ?>
						<div style="float:left;">
							<input type="radio" name="advancedparams[limit_<?php echo $type; ?>]" value="1" <?php if ( $active == 1 ) { echo 'checked="checked"'; } ?> />
							<label class="hasTip" title="<?php echo JText::sprintf( 'Selection (description)', JText::_( $name ) ); ?>">
								<?php echo JText::_( 'Selection' ); ?>
							</label>
						</div>
					<?php endif; ?>
					<?php if ( $options > 1 ) : ?>
						<div style="float:left;">
							<input type="radio" name="advancedparams[limit_<?php echo $type; ?>]" value="2" <?php if ( $active== 2 ) { echo 'checked="checked"'; } ?> />
							<label class="hasTip" title="<?php echo JText::sprintf( 'Exclude Selection (description)', JText::_( $name ) ); ?>">
								<?php echo JText::_( 'Exclude Selection' ); ?>
							</label>
						</div>
					<?php endif; ?>
					<?php if ( $options > 2 ) : ?>
						<div style="float:left;">
							<div id="advancedparams[match_method].and" class="nntoggler nntoggler_nofx" style="visibility: hidden;">
							<input type="radio" name="advancedparams[limit_<?php echo $type; ?>]" value="3" <?php if ( $active == 3 ) { echo 'checked="checked"'; } ?> />
								<label class="hasTip" title="<?php echo JText::sprintf( 'None (description)', JText::_( $name ) ); ?>">
									<?php echo JText::_( 'None' ); ?>
								</label>
							</div>
						</div>
					<?php endif; ?>
					</td>
				</tr>
			</table>
		<?php if ( $options > 0 ) : ?>
			<div id="advancedparams[limit_<?php echo $type; ?>].1<?php if ( $options > 1 ) : ?> advancedparams[limit_<?php echo $type; ?>].2<?php endif; ?>" class="nntoggler" style="visibility: hidden;">
				<table class="admintable" cellspacing="1">
				<?php if ( $type == 'date' ) : ?>
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Start Publishing' ); ?>:
						</td>
						<td>
							<?php echo $lists['publish_up']; ?>
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Finish Publishing' ); ?>:
						</td>
						<td>
							<?php echo $lists['publish_down']; ?>
						</td>
					</tr>
				<?php else: ?>
					<tr>
						<td valign="top" class="key">
							<div>
								<div id="advancedparams[limit_<?php echo $type; ?>].1" class="nntoggler" style="visibility: hidden;">
									<?php echo JText::_( 'Include' ); ?>
								</div>
							<?php if ( $options > 1 ) : ?>
								<div id="advancedparams[limit_<?php echo $type; ?>].2" class="nntoggler" style="visibility: hidden;">
									<?php echo JText::_( 'Exclude' ); ?>
								</div>
							<?php endif; ?>
							</div>
						</td>
						<td>
							<?php echo $lists[$type]; ?>
						</td>
					</tr>
				<?php endif; ?>
				</table>
			</div>
		<?php endif; ?>
		</fieldset>
<?php
	}
// <<< (C) NoNumber! <<<
}