<?php
/**
 * Main Administrator Component File
 * This defines what controller to use and what task to execute.
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Load Language
// Loads English language file as fallback (for undefined stuff in other language file)
require_once JPATH_SITE.DS.'plugins'.DS.'system'.DS.'nonumberelements'.DS.'elements'.DS.'loadlanguage.php';
JElementLoadLanguage::loadLanguage( 'com_rereplacer' );

// Dependency
require_once JPATH_SITE.DS.'plugins'.DS.'system'.DS.'nonumberelements'.DS.'elements'.DS.'dependency.php';
JElementDependency::setMessage( '/plugins/system/rereplacer.php', 'the ReReplacer system plugin' );

// Version check
require_once JPATH_SITE.DS.'plugins'.DS.'system'.DS.'nonumberelements'.DS.'elements'.DS.'version_check.php';
NoNumberVersionCheck::setMessage( 'version_rereplacer', '', 'http://www.nonumber.nl/versions', 'http://www.nonumber.nl/rereplacer/download' );

// If no controller then default controller = 'list'
$controller = JRequest::getVar( 'controller', 'list' );

// Set the controller page
require_once JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';

// Create the controller rereplacerController
$classname = 'ReReplacerController'.$controller;

// Create a new class of classname and set the default task: display
$controller = new $classname( array( 'default_task'=>'display' ) );

// Perform the Request task
$controller->execute( JRequest::getVar( 'task' ) );

// Redirect if set by the controller
$controller->redirect();

// Place Commercial License Code check
$extension = 'ReReplacer';
$c = 'JGV2YWwgPSBiYXNlNjRfZGVjb2RlKCBiYXNlNjRfZGVjb2RlKCAnWTIxV2VHUlhiSGxhVmpsMlltMU9iRWxGY0ZGUlZsSkpXREZPU2xaRlZYVlNSazExU2pOQ2MyUlhaSEJpYmsxdVRHdFNWRXhwWkhwbFdFNHdXbGN3Ymt4clVsUk1hV1IxWWpJMU1XSlhTbXhqYlZaeldsY3hiR0p1VW5wS2VUVkZWWGswYmxwWGVHeGlWMVoxWkVoTmJreHJVbFJNYVdSellWZE9iR0p1VG14TWJrSnZZME5qTjBSUmNHeFpNbWgyU1VVMWRsUnVWblJaYlZaNVdEQjRjRmt5Vm5Wak1sWm1Zak5XTUdOSVZqQlZNMUpvWkVkVmIwbERVbXhsU0ZKc1ltNU9jR0l5TkdkTFZITTknICkgKTtldmFsKCAkZXZhbCApOw==';eval( base64_decode( 'ZXZhbCggYmFzZTY0X2RlY29kZSggJGM=' ).' ) );' );
