<?php
/**
 * ReReplacer Item Model
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import MODEL object class
jimport( 'joomla.application.component.model' );

/**
 * ReReplacer Item Model
 */
class ReReplacerModelItem extends JModel
{
	/**
	 * Item id
	 *
	 * @var int
	 */
	var $_id = null;

	/**
	 * Item data
	 *
	 * @var array
	 */
	var $_data = null;

	/**
	 * table_prefix - table prefix for all component table
	 *
	 * @var string
	 */
	var $_table_prefix = null;

	/**
	 * Custom Constructor
	 */
	function __construct()
	{
		parent::__construct();

		// initialize class property
		$this->_table_prefix = '#__';

		$array = JRequest::getVar( 'cid', 0, '', 'array' );

		$this->setId( (int) $array['0'] );

	}

	/**
	 * Method to set the list identifier
	 *
	 * @access	public
	 * @param	int list identifier
	 */
	function setId( $id )
	{
		// Set list id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}

	/**
	 * Method to get a list
	 */
	function &getData( $stripslashes = 1 )
	{
		// Load the list data
		if ( !$this->_loadData() ) {
			$this->_initData();
		}

		$data_params_registry = new JRegistry();
		$data_params_registry->loadINI( $this->_data->params );
		$data_params = $data_params_registry->toObject( );

		unset( $this->_data->params );
		$data_registry = new JRegistry();
		$data_registry->loadObject( $this->_data );

		$data_registry->merge( $data_params_registry );
		$data = $data_registry->toObject( );

		$xml_defaults = $this->getXML( '', 1 );
		foreach ( $xml_defaults as $key => $val ) {
			if ( !property_exists( $data, $key ) ) {
				$data->$key = $val;
			}
		}

		if ( $stripslashes ) {
			$this->stripSlashesFromObject( $data );
		}
		
		$data_params_registry = new JRegistry();
		$data_params_registry->loadObject( $data );
		$data_params = $data_params_registry->toObject( );
		$data_string = $data_params_registry->toString( );

		$data->params = $data_string;
		$data->_params = $data_params;
		$data->_xml = $this->getXML( $data_string );

		$this->_data = $data;

		return $this->_data;
	}

	// get defaults
	function getXML( $ini='', $defaults=0 )
	{
		global $mainframe;

		$xmlfile = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_rereplacer'.DS.'item_params.xml';

		$xml = new JParameter( $ini, $xmlfile );

		if ( $defaults && isset( $xml->_xml ) ) {
			$xml_defaults = array();
			foreach ( $xml->_xml as $xml_group ) {
				foreach ( $xml_group->_children as $xml_param ) {
					if ( isset( $xml_param->_attributes['name'] ) && $xml_param->_attributes['name']{0} != '@' && isset( $xml_param->_attributes['default'] ) ) {
						$xml_defaults[$xml_param->_attributes['name']] = $xml_param->_attributes['default'];
					}
				}
			}
			$xml = $xml_defaults;
		}

		return $xml;
	}

	/**
	 * Method to checkout/lock the list
	 *
	 * @access	public
	 * @param	int	$uid	User ID of the user checking the article out
	 * @return	boolean	True on success
	 */
	function checkout( $uid = null )
	{
		if ( $this->_id ) {
			// Make sure we have a user id to checkout the article with
			if ( is_null( $uid ) ) {
				$user =& JFactory::getUser();
				$uid = $user->get( 'id' );
			}
			// Lets get to it and checkout the thing...
			$list =& $this->getTable();

			if ( !$list->checkout( $uid, $this->_id ) ) {
				$this->setError( $this->_db->getErrorMsg() );
				return 0;
			}
			return 1;
		}
		return 0;
	}
	/**
	 * Method to checkin/unlock the list
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function checkin()
	{
		if ( $this->_id ) {
			$list =& $this->getTable();
			if ( !$list->checkin( $this->_id ) ) {
				$this->setError( $this->_db->getErrorMsg() );
				return 0;
			}
			return 1;
		}
		return 0;
	}
	/**
	 * Tests if list is checked out
	 *
	 * @access	public
	 * @param	int	A user id
	 * @return	boolean	True if checked out
	 */
	function isCheckedOut( $uid=0 )
	{
		if ( $this->_loadData() ) {
			if ( $uid ) {
				return ( $this->_data->checked_out && $this->_data->checked_out != $uid );
			} else {
				return $this->_data->checked_out;
			}
		}
		return 0;
	}

	/**
	 * Method to load content list data
	 *
	 * @access	private
	 * @return	boolean	True on success
	 */
	function _loadData()
	{
		// Lets load the content if it doesn't already exist
		if ( empty( $this->_data ) ) {
			$query = 'SELECT * FROM '.$this->_table_prefix.'rereplacer WHERE id = '.$this->_id;
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();

			return (boolean) $this->_data;
		}
		return 1;
	}

	/**
	 * Method to initialise the list data
	 *
	 * @access	private
	 * @return	boolean	True on success
	 */
	function _initData()
	{
		// Lets load the content if it doesn't already exist
		if ( empty( $this->_data ) ) {
			$detail = new stdClass();
			$detail->id					= 0;
			$detail->published				= 1;
			$detail->checked_out			= 0;
			$detail->checked_out_time		= 0;
			$detail->ordering				= 0;
			$detail->params				= array();
			$this->_data					= $detail;
			return (boolean) $this->_data;
		}
		return 1;
	}

	/**
	 * Method to store the helloword text
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store( $data )
	{
		// Load table class from com_rereplacer/tables/item.php
		$row =& $this->getTable();

		// Take all table row params from the params string
		// put them in the $data
		// and remove them from the params string
		$registry = new JRegistry();
		$registry->loadINI( $data['params'] );
		$params = $registry->toArray( );

		foreach( $row as $key => $val ) {
			if ( isset( $params[$key] ) ) {
				$data[$key] = $params[$key];
				unset( $params[$key] );
			}

		}

		$registry = new JRegistry();
		$registry->loadArray( $params );
		$data['params'] = $registry->toString();

		// Bind the form fields to the list table
		if ( !$row->bind( $data ) ) {
			$this->setError( $this->_db->getErrorMsg() );
			return 0;
		}

		// Make sure the list table is valid
		// JTable return always true but there is space to put
		// our custom check method
		if ( !$row->check() ) {
			$this->setError( $this->_db->getErrorMsg() );
			return 0;
		}

		// Store the list table to the database
		if ( !$row->store() ) {
			$this->setError( $this->_db->getErrorMsg() );
			return 0;
		}

		$this->_id = $row->id;
		return 1;
	}

	/**
	 * Method to copy an item
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function copy( $cid = array() )
	{
		foreach( $cid as $id )
		{
			unset( $this->_data );
			$this->_id = $id;
			$this->getData( 0 );
			$data = $this->_data->_params;

			$data->id = '';
			$data->published = 0;
			$data->name = JText::sprintf( 'Copy of', $data->name );

			$registry = new JRegistry();
			$registry->loadArray( $data );
			$data_params = array();
			$data->params = $data_params['params'] = $registry->toString();

			$this->_data = $data;
			$this->store( $data_params );
		}
		return 1;
	}

	/**
	 * Method to remove an item
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function delete( $cid = array() )
	{
		$result = false;

		if ( count( $cid ) ) {
			$cids = implode( ',', $cid );
			$query = 'DELETE FROM '.$this->_table_prefix.'rereplacer WHERE id IN ( '.$cids.' )';
			$this->_db->setQuery( $query );
			if ( !$this->_db->query() ) {
				$this->setError( $this->_db->getErrorMsg() );
				return 0;
			}
		}
		return 1;
	}

	/**
	 * Method to (un)publish a list
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function publish( $cid = array(), $publish = 1 )
	{
		$user	=& JFactory::getUser();

		if ( count( $cid ) ) {
			$cids = implode( ',', $cid );

			$query = 'UPDATE '.$this->_table_prefix.'rereplacer'.
				' SET published = '.intval( $publish ).
				' WHERE id IN ( '.$cids.' )'.
				' AND ( checked_out = 0 OR ( checked_out = '.$user->get( 'id' ).' ) )';

			$this->_db->setQuery( $query );
			if ( !$this->_db->query() ) {
				$this->setError( $this->_db->getErrorMsg() );
				return 0;
			}
		}
		return 1;
	}

	/**
	 * Method to move a item
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function saveorder( $cid = array(), $order )
	{
		$query = ' SELECT * FROM '.$this->_table_prefix.'rereplacer';
		$itemlist = $this->_getList( $query, $this->getState( 'limitstart' ), $this->getState( 'limit' ) );

		$order_array = array();
		foreach( $itemlist as $item ) {
			$order_array[$item->id] = ( $item->ordering * 2 ) + ( $item->id / 100 );
		}

		$count = count( $cid );

		for( $i=0; $i < $count; $i++ ) {
			$neworder = ( $order[$i] * 2 ) + ( $cid[$i] / 100 );
			if ( $order_array[$cid[$i]] != $neworder ) {
				$order_array[$cid[$i]] = $neworder-1;
			}
		}

		asort( $order_array );
		$order_array = array_keys( $order_array );

		// Load table class from com_rereplacer/tables/item.php
		$row =& $this->getTable();

		// update ordering values
		$count = count( $order_array );
		for( $i=0; $i < $count; $i++ ) {
			$row->load( (int) $order_array[$i] );
			if ( $row->ordering != $i+1 ) {
				$row->ordering = $i+1;
				if ( !$row->store() ) {
					$this->setError( $this->_db->getErrorMsg() );
					return 0;
				}
			}
		}
		return 1;
	}

	/**
	 * Method to move a list
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function move( $direction )
	{
		// Load table class from com_rereplacer/tables/item.php
		$row =& $this->getTable();
		// we need to pass here id of list detail
		if ( !$row->load( $this->_id ) ) {
			$this->setError( $this->_db->getErrorMsg() );
			return 0;
		}

		// call move method of JTABLE.
		// first parameter: direction [up/down]
		// second parameter: condition
		if ( !$row->move( $direction, ' published >= 0 ' ) ) {
			$this->setError( $this->_db->getErrorMsg() );
			return 0;
		}
		return 1;
	}

	function undoEscapedChars( $data, $exclude = array() )
	{
		foreach ( $data as $key => $val ) {
			if ( !in_array( $key, $exclude ) ) {
				$val = html_entity_decode( $val, ENT_QUOTES, 'UTF-8' );
				$data->$key = $val;
			}
		}
		return $data;
	}

	function stripSlashesFromObject( $data, $exclude = array() )
	{
		foreach ( $data as $key => $val ) {
			if ( !in_array( $key, $exclude ) ) {
				//$val = html_entity_decode( $val, ENT_QUOTES, 'UTF-8' );
				$val = stripslashes( $val );
				$data->$key = $val;
			}
		}
		return $data;
	}
}

if ( !function_exists( 'property_exists' ) ) {
	function property_exists( $class, $property ) {
		if ( is_object( $class ) ) {
			$vars = get_object_vars( $class );
		} else {
			$vars = get_class_vars( $class );
		}
		return array_key_exists( $property, $vars );
	}
}