<?php
/**
 * ReReplacer Item View
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import VIEW object class
jimport( 'joomla.application.component.view' );

/**
 * ReReplacer Item View
 */
class ReReplacerViewItem extends JView
{
	/**
	 * Display the view
	 */
	function display( $tpl = null )
	{

		global $mainframe, $option;

		// set document title
		$document =& JFactory::getDocument();
		$document->setTitle( JText::_( 'ReReplacer Item' ) );
		$document->addStyleSheet( JURI::root( true ).'/administrator/components/com_rereplacer/css/rereplacer.css' );

		$uri	=& JFactory::getURI();
		$user	=& JFactory::getUser();
		$model	=& $this->getModel();

		// prepare array
		$lists = array();

		// get the rereplacer
		$detail	=& $this->get( 'data' );

		// the new record ? Edit or Create?
		$isNew		= ( $detail->id < 1 );

		// fail if checked out not by 'me'
		if ( $model->isCheckedOut( $user->get( 'id' ) ) ) {
			$msg = JText::sprintf( 'DESCBEINGEDITTED', JText::_( 'THE DETAIL' ), $detail->descript );
			$mainframe->redirect( 'index.php?option='. $option, $msg );
		}

		// Set toolbar items for the page
		$text = $isNew ? JText::_( 'NEW' ) : JText::_( 'EDIT' );
		JToolBarHelper::title( JText::_( 'Item' ).': <small><small>[ '.$text.' ]</small></small>', 'rereplacer.png' );
		JToolBarHelper::save();
		JToolBarHelper::apply();
		if ( $isNew ) {
			JToolBarHelper::cancel();
		} else {
			// for existing items the button is renamed `close`
			JToolBarHelper::cancel( 'cancel', 'Close' );
		}
		JToolBarHelper::help( 'help', TRUE );

		// Edit or Create?
		if ( !$isNew ) {
			$model->checkout( $user->get( 'id' ) );
		} else {
			// initialise new record
			$detail->published = 1;
			$detail->order	= 0;
		}

		// build the html select list
		$lists['published']		= JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $detail->published );

		//  Clear rereplacer HTML data
		jimport( 'joomla.filter.filteroutput' );
		JFilterOutput::objectHTMLSafe( $detail, ENT_QUOTES );

		$this->assignRef( 'lists',		$lists );
		$this->assignRef( 'detail',		$detail );
		$this->assignRef( 'request_url',	$uri->toString() );

		parent::display( $tpl );
	}

}