<?php
/**
 * ReReplacer Item View Template
 *
 * @package     ReReplacer
 * @version     2.6.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import modal
JHTML::_( 'behavior.modal' );
// Import html tooltips
JHTML::_( 'behavior.tooltip' );

echo JText::_( 'Item information' );

$has_k2				= JFile::exists( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'admin.k2.php' );
$has_jsresources	= JFile::exists( JPATH_SITE.DS.'components'.DS.'com_resource'.DS.'resource.php' );
?>
<p></p>
<form action="<?php echo JRoute::_( $this->request_url ) ?>" method="post" name="adminForm" id="adminForm">
<input type="hidden" name="params[has_k2]" id="paramshas_k2" value="<?php echo $has_k2; ?>" />
<input type="hidden" name="params[has_jsresources]" id="paramshas_jsresources" value="<?php echo $has_jsresources; ?>" />

<div class="col width-50">
	<fieldset class="adminform">
		<legend><?php echo JText::_( 'Details' ); ?></legend>
		<?php echo $this->detail->_xml->render(); ?>
	</fieldset>
	<fieldset class="adminform">
		<legend><?php echo JText::_( 'Search & Replace' ); ?></legend>
		<?php echo $this->detail->_xml->render( 'params', 'search' ); ?>
	</fieldset>
	<fieldset class="adminform">
		<legend><?php echo JText::_( 'Syntax help' ); ?></legend>
		<?php echo $this->detail->_xml->render( 'params', 'syntaxhelp' ); ?>
	</fieldset>
</div>
<div class="col width-50" style="padding-top: 7px;">
	<?php
		jimport( 'joomla.html.pane' );
        $pane =& JPane::getInstance( 'sliders', array( 'allowAllClose' => true ) );

		echo $pane->startPane( 'rereplacer_pane' );
			echo $pane->startPanel( JText::_( 'Search options' ), 'search-page' );
			echo $this->detail->_xml->render( 'params', 'options' );
			echo $pane->endPanel();

			echo $pane->startPanel( JText::_( 'Search areas' ), 'areas-page' );
				echo $this->detail->_xml->render( 'params', 'areas' );

			echo $pane->endPanel();

			echo $pane->startPanel( JText::_( '-Publishing Assignments' ), 'assignments-page' );
				echo $this->detail->_xml->render( 'params', 'assignments' );
				echo $this->detail->_xml->render( 'params', 'assignments_else' );
			echo $pane->endPanel();
		echo $pane->endPane();
	?>
</div>

<div class="clr"></div>

<input type="hidden" name="cid[]" value="<?php echo $this->detail->id; ?>" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="controller" value="item" />
</form>

<script language="javascript" type="text/javascript">
	function submitbutton( pressbutton )
	{
		if ( pressbutton == 'cancel' ) {
			submitform( pressbutton );
			return;
		}

		// do field validation
		passCheck = checkFields();
		if ( passCheck ) {
			submitform( pressbutton );
		}
	}

	function checkFields()
	{
		var form = document.adminForm;
		msg = '';
		// do field validation
		if ( form['params[name]'].value == '' ) {
			msg = '<?php echo JText::_( 'The item must have a name', true ); ?>';
		} else if ( form['params[search]'].value == '' ) {
			msg = '<?php echo JText::_( 'The item must have something to search for', true ); ?>';
		}
		if ( msg != '' ) {
			alert( msg );
			return 0;
		} else {
			return checkFields_2();
		}
	}
	function checkFields_2()
	{
		var form = document.adminForm;
		msg = '';
		// do field validation
		if ( form['params[search]'].value.trim() != '' && form['params[search]'].value.trim().length < 3 ) {
			msg = '<?php echo JText::_( 'The search string should be longer than 2 characters.', true ); ?>';
		} else if (
			( form['params[between_start]'].value.trim() != '' && form['params[between_start]'].value.trim().length < 3 ) ||
			( form['params[between_end]'].value.trim() != '' && form['params[between_end]'].value.trim().length < 3 )
		) {
			msg = '<?php echo JText::_( 'The values of the \'Only search between\' fields should be longer than 2 characters.', true ); ?>';
		}
		if ( msg != '' ) {
			alert( msg );
			return 0;
		} else {
			return 1;
		}
	}
	checkFields_2();
</script>